﻿using System.Collections;
using System.Collections.Generic;
using Unity.Mathematics;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class EndController : MonoBehaviour
{
    public Text scoreText;

    public GameObject dialogBox;
    public Text dialogText;
    public SpriteRenderer background;

    protected List<string> outroDialogTexts = new List<string>();

    protected int dialogIdx = 0;

    protected bool fading = false;
    protected float fade = 1f;

    // Start is called before the first frame update
    void Start()
    {
        int score = 0;

        if (ScoreBoard.Instance.flags == null)
        {
            ScoreBoard.Instance.flags = new HashSet<string>() { "True Coffee", "True Bread", "Pickup Phone" };
        }

        if (ScoreBoard.Instance.flags.Contains("Coffee") || ScoreBoard.Instance.flags.Contains("True Coffee"))
        {
            ++score;
            outroDialogTexts.Add("By preparing some coffee you got Richard to relax enough to reminisce about his time as a cook.");
            outroDialogTexts.Add("The feeling made you remember details about your own profession. You used to be an investigator of sorts, maybe for the police?");
            outroDialogTexts.Add("No, it feels like it was something more specific. Maybe that has something to do with what happened to you.");
        }

        if (ScoreBoard.Instance.flags.Contains("Bread") || ScoreBoard.Instance.flags.Contains("True Bread"))
        {
            ++score;
            outroDialogTexts.Add("While baking the bread you felt something strange, the control you had over the weight, temperature and dimensions of the dough was extraordinary, magical even.");
            outroDialogTexts.Add("That must have been what you felt when you first possessed Richard, he had control over things in a way that was not normal.");
            outroDialogTexts.Add("That feeling wasn't too unfamiliar to you, you felt like you had something like that before too.");
            outroDialogTexts.Add("You start to remember, you could see things other people couldn't, you could talk to them, and they would talk back.");
            outroDialogTexts.Add("Maybe this has something to do with how you were able to possess and control Richard.");
        }

        if (ScoreBoard.Instance.flags.Contains("Pickup Phone"))
        {
            ++score;
            outroDialogTexts.Add("The message on Richard's phone, you knew that name. Richard is being controlled by someone else, in a way that is a lot more effective than a mere ghostly possession.");
            outroDialogTexts.Add("You know the next victim, she hired you for your final case. Her son had been kidnaped, he wasn't a regular kid, he was very special, even among special people.");
            outroDialogTexts.Add("She is next to be disposed of, just like you were. You must stop Richard, and then find a way to stop whoever is behind all of this.");
            outroDialogTexts.Add("TO BE CONTINUED...(?)");
        }

        outroDialogTexts.Add("");

        scoreText.text = "You found " + score + " clues out of 3";

        dialogText.text = outroDialogTexts[0];
    }

    // Update is called once per frame
    void Update()
    {
        if (fading)
        {
            fade = math.lerp(fade, 0f, Time.deltaTime);

            Color c = dialogBox.GetComponent<Image>().color;
            dialogBox.GetComponent<Image>().color = new Color(c.r, c.g, c.b, fade);

            c = scoreText.color;
            scoreText.color = new Color(c.r, c.g, c.b, fade);

            c = dialogText.color;
            dialogText.color = new Color(c.r, c.g, c.b, fade);

            c = background.color;
            background.color = new Color(c.r, c.g, c.b, fade);

            if (fade < .01f)
            {
                SceneManager.LoadScene("Menu");
            }
        }

        if (Input.GetButtonDown("Interact"))
        {
            ++dialogIdx;

            if (dialogIdx < outroDialogTexts.Count)
            {
                dialogText.text = outroDialogTexts[dialogIdx];
            }

            if (dialogIdx + 1 >= outroDialogTexts.Count)
            {
                fading = true;
            }
        }
    }
}
